# ---------------------------------------------------------------------------------------------------------------------
# PARAMETRY WYMAGANE
# Konieczne jest podanie wartości dla każdego z tych parametrów.
# ---------------------------------------------------------------------------------------------------------------------

variable "cluster_name" {
  description = "Nazwa używana we wszystkich zasobach klastra"
  type        = string
}

variable "db_remote_state_bucket" {
  description = "Nazwa kubełka S3 dla zdalnych informacji o stanie bazy danych"
  type        = string
}

variable "db_remote_state_key" {
  description = "Ścieżka dostępu do zdalnych informacji o stanie bazy danych w S3"
  type        = string
}

variable "instance_type" {
  description = "Typ egzemplarza EC2 do uruchomienia (np. t2.micro)"
  type        = string
}

variable "min_size" {
  description = "Minimalna liczba egzemplarzy EC2 w ASG"
  type        = number
}

variable "max_size" {
  description = "Maksymalna liczba egzemplarzy EC2 w ASG"
  type        = number
}

variable "enable_autoscaling" {
  description = "Wartość true oznacza włączenie automatycznego skalowania"
  type        = bool
}

# ---------------------------------------------------------------------------------------------------------------------
# PARAMETRY OPCJONALNE
# Te parametry mają rozsądne wartości domyślne.
# ---------------------------------------------------------------------------------------------------------------------

variable "ami" {
  description = "Obraz AMI do uruchomienia w klastrze"
  type        = string
  default     = "ami-0fb653ca2d3203ac1"
}

variable "server_text" {
  description = "Ciąg tekstowy zwracany przez serwer"
  type        = string
  default     = "Witaj, świecie"
}

variable "custom_tags" {
  description = "Własne tagi przeznaczone do użycia w egzemplarzach ASG"
  type        = map(string)
  default     = {}
}

variable "server_port" {
  description = "Numer portu używany przez serwer dla żądań HTTP"
  type        = number
  default     = 8080
}
